/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.quanyi.center.api.enums.coupon.autocreate;

import java.util.Arrays;

public enum DirectPayMethodEnum {
    NOT_SPECIFIED(0, "\u4e0d\u6307\u5b9a"),
    BANK_CARD(1, "\u94f6\u884c\u5361"),
    SMALL_CHANGE(2, "\u96f6\u94b1");

    private final int code;
    private final String desc;

    public static boolean isValidPayMethod(int code) {
        return Arrays.stream(DirectPayMethodEnum.values()).anyMatch(t -> t.getCode() == code);
    }

    public static DirectPayMethodEnum getByCode(int code) {
        return Arrays.stream(DirectPayMethodEnum.values()).filter(t -> t.getCode() == code).findFirst().orElse(null);
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private DirectPayMethodEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}

