package cn.com.duiba.quanyi.center.api.param.pay.ext;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;


/**
 * 邮储银行支付
 *
 * @author wangguanhua
 */
@Data
public class PsbcPayCreateOrderParam implements Serializable {

    private static final long serialVersionUID = -2990023788775631979L;

    /**
     * 商户号
     */
    @NotBlank(message = "商户号不能为空")
    private String merchantCode;

    /**
     * 服务商页订单详情页url（用于支付成功页跳转）
     */
    @NotBlank(message = "服务商页订单详情页url不能为空")
    private String backLink;
}
