package cn.com.duiba.quanyi.center.api.dto.activity;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 定制活动支付记录表
 * @author mybatis generator 
 * @date 2024-07-23
 */
@Data
public class CustomActivityPayRecordDto implements Serializable {
     
    private static final long serialVersionUID = 17217013706858419L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型
     */
    private Integer activityType;

    /**
     * 支付金额，单位分
     */
    private Long payAmount;

    /**
     * 支付订单号
     */
    private String bizOrderNo;

    /**
     * 是否支付成功
     */
    private Integer paySuccess;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 扩展字段
     */
    private String extraJson;

    @Data
    public static class PayRecordExtraJson{
        /**
         * 支付维度
         * @see cn.com.duiba.quanyi.center.api.enums.activity.ActivityPayScopeEnum
         */
        private Integer payScope;
        /**
         * 奖品
         */
        private List<Long> prizeIdList;
        /**
         * 是否需要支付
         */
        private Integer needPay;
    }
}