package cn.com.duiba.quanyi.center.api.dto.settlement.receive;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 回款与发票关联关系
 * @author mybatis generator 
 * @date 2024-12-11
 */
@Data
public class ReceivedPaymentInvoiceRefDto implements Serializable {
     
    private static final long serialVersionUID = 17338978956825752L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 删除的记录ID
     */
    private Long deleteRecordId;

    /**
     * 记录ID
     */
    private Long recordId;

    /**
     * 回款ID
     */
    private Long receiveId;

    /**
     * 发票ID
     */
    private Long invoiceId;

    /**
     * 回款金额
     */
    private Long refAmount;

    /**
     * 发票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 客户ID
     */
    private Long partnerId;
}