package cn.com.duiba.quanyi.center.api.remoteservice.statistic;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.statistic.ContractStatisticDto;
import cn.com.duiba.quanyi.center.api.param.statistic.ContractStatisticSearchParam;

import java.util.List;
import java.util.Set;

/**
 * 合同统计表
 * @author kjj mybatis generator 
 * @date 2024-07-18
 */
@AdvancedFeignClient
public interface RemoteContractStatisticService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 合同统计集合
     */
    List<ContractStatisticDto> selectPage(ContractStatisticSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ContractStatisticSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 合同统计
     */
    ContractStatisticDto selectById(Long id);

    /**
     * 根据合同ID查询
     *
     * @param contractId 合同ID
     * @return 结果
     */
    ContractStatisticDto selectByContractId(Long contractId);

    /**
     * 根据合同ID查询
     *
     * @param contractIds 合同ID集合
     * @return 结果
     */
    List<ContractStatisticDto> selectByContractIds(Set<Long> contractIds);

    /**
     * 新增
     * @param dto 合同统计
     * @return 执行结果
     */
    int insert(ContractStatisticDto dto);

    /**
     * 更新
     * @param dto 合同统计
     * @return 影响行数
     */
    int update(ContractStatisticDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}