package cn.com.duiba.quanyi.center.api.dto.bank.hzbank;

import cn.com.duiba.quanyi.center.api.param.bank.hzbank.BaseRequestParam;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @author: LuHui
 * @date: 2024/4/7 16:38
 * @description:
 */
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Data
public class NotifySftpDto extends BaseRequestParam implements Serializable {
    private static final long serialVersionUID = 6743353977411981594L;
    /**
     * 通知时间
     */
    private String noticeTime;
    /**
     * 类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.bank.hzbank.NotifyTypeEnum
     */
    private String type;
    /**
     * 对账起始时间（对账类型必传字段）
     */
    private String billStartTime;
    /**
     * 对账结束时间（对账类型必传字段）
     */
    private String billEndTime;
    /**
     * 权益货品维护为ZIP⽂件， 对账为CSV⽂件,每个⽂件名不超过64位
     */
    private List<String> fileName;

    /**
     * 唯一批次号
     */
    private String batchNo;
}
