package cn.com.duiba.quanyi.center.api.remoteservice.demand;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.demand.DemandPaymentInfoCommentDto;
import cn.com.duiba.quanyi.center.api.param.demand.DemandPaymentInfoCommentSearchParam;
import java.util.List;

/**
 * 付款申请评论
 * @author kjj mybatis generator 
 * @date 2024-12-03
 */
@AdvancedFeignClient
public interface RemoteDemandPaymentInfoCommentService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 付款申请评论集合
     */
    List<DemandPaymentInfoCommentDto> selectPage(DemandPaymentInfoCommentSearchParam param);

    /**
     * 不分页查询
     * @param param
     * @return
     */
    List<DemandPaymentInfoCommentDto> selectNotPage(DemandPaymentInfoCommentSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DemandPaymentInfoCommentSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 付款申请评论
     */
    DemandPaymentInfoCommentDto selectById(Long id);

    /**
     * 新增
     * @param dto 付款申请评论
     * @return 执行结果
     */
    int insert(DemandPaymentInfoCommentDto dto);

    /**
     * 新增
     * @param dto 付款申请评论
     * @return 执行结果
     */
    int insertAndSendDingTalk(DemandPaymentInfoCommentDto dto);

    /**
     * 更新
     * @param dto 付款申请评论
     * @return 影响行数
     */
    int update(DemandPaymentInfoCommentDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}