package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 抖音支付券类型
 */
@Getter
@AllArgsConstructor
public enum DouYinCouponTypeEnum {


    MJ("MJ", "定额立减"),
    RANDOM("RANDOM", "随机立减"),
    ;

    private final String type;

    private final String desc;

    private static final Map<String, DouYinCouponTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(DouYinCouponTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static DouYinCouponTypeEnum getByType(String type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
