package cn.com.duiba.quanyi.center.api.param.external;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 外部订单批次号
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ExternalOrderCouponSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17332135616364915L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 渠道ID
     */
    private Long channelId;

    /**
     * 三方活动ID
     */
    private String thirdActivityId;

    /**
     * 三方活动ID集合
     */
    private List<String> thirdActivityIdList;

    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动名称集合
     */
    private List<String> activityNameList;


    /**
     * 钱包号
     */
    private String walletNum;

    /**
     * 钱包号集合
     */
    private List<String> walletNumList;

    /**
     * 批次号，渠道id_活动ID/钱包号
     */
    private String stockId;

    /**
     * 创建人
     */
    private Long createOperatorId;

    /**
     * 创建人姓名
     */
    private String createOperatorName;

    /**
     * 项目ID
     */
    private Long projectId;

    /**
     * 需求ID
     */
    private Long demandId;

    /**
     * 需求商品ID
     */
    private Long demandGoodsId;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;
}