package cn.com.duiba.quanyi.center.api.remoteservice.holo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.BaseResultDto;
import cn.com.duiba.quanyi.center.api.dto.holo.DownloadReportDto;
import cn.com.duiba.quanyi.center.api.dto.holo.DownloadReportSaveOrUpdateDto;
import cn.com.duiba.quanyi.center.api.param.holo.DownloadReportSearchParam;
import java.util.List;

/**
 * 下载报表配置
 * @author kjj mybatis generator 
 * @date 2024-08-07
 */
@AdvancedFeignClient
public interface RemoteDownloadReportService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 下载报配置集合
     */
    List<DownloadReportDto> selectPage(DownloadReportSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(DownloadReportSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 下载报配置
     */
    DownloadReportDto selectById(Long id);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    BaseResultDto<Boolean> delete(Long id);

    /**
     * 新增
     * @param dto 下载报配置
     * @return 执行结果
     */
    BaseResultDto<Long> save(DownloadReportSaveOrUpdateDto dto);

    /**
     * 更新
     * @param dto 下载报配置
     * @return 影响行数
     */
    BaseResultDto<Long> update(DownloadReportSaveOrUpdateDto dto);


    /**
     * 更新
     * @param dto 下载报配置
     * @return 影响行数
     */
    int updateReport(DownloadReportDto dto);

}