package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementRefDto;

import java.util.List;

/**
 * 结算单关联的id
 * @author kjj mybatis generator 
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementRefService {

    /**
     * 根据结算单查询
     * @param settlementId 结算单ID
     * @return 结算单关联的id
     */
    List<SettlementRefDto> selectBySettlementId(Long settlementId);

    /**
     * 根据关联的id，查询相关结算单ID
     * @param bizType 关联id类型，1-对接人ID，2-需求ID
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementRefBizTypeEnum
     * @param bizId 关联ID
     * @return 结算单ID列表
     */
    List<Long> selectSettlementIdsByBiz(Integer bizType, Long bizId);
}