package cn.com.duiba.quanyi.center.api.remoteservice.insurance.institution;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.insurance.company.InsuranceCompanyStatDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.institution.InsuranceInstitutionDto;
import cn.com.duiba.quanyi.center.api.dto.insurance.institution.InsuranceInstitutionStatDto;

import java.util.List;

/**
 * 保司机构统计表
 * @author kjj mybatis generator 
 * @date 2024-03-04
 */
@AdvancedFeignClient
public interface RemoteInsuranceInstitutionStatService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 保司机构统计
     */
    InsuranceInstitutionStatDto selectById(Long id);


    /**
     * 根据机构ID列表，查询统计数据
     * @param institutionIds
     * @return
     */
    List<InsuranceInstitutionStatDto> selectByInstitutionIds(List<Long> institutionIds);


    /**
     * 根据机构ID，查询统计数据
     * @param institutionId
     * @return
     */
    InsuranceInstitutionStatDto selectByInstitutionId(Long institutionId);


    /**
     * 新增
     * @param dto 保司公司统计
     * @return 执行结果
     */
    int insert(InsuranceInstitutionStatDto dto);

    /**
     * 更新
     * @param dto 保司公司统计
     * @return 影响行数
     */
    int update(InsuranceInstitutionStatDto dto);
}