package cn.com.duiba.quanyi.center.api.enums.abc;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

/**
 * @author nongfu
 * @Date 2024/12/10 19:46
 */
@AllArgsConstructor
@Getter
public enum AbcBillTaskEnum {


    INIT(0, "待推送"),
    INIT_STATUS(1, "推送中"),
    SUCCESS(2, "推送成功"),
    FAIL(3, "推送失败"),
    PERFECT(4, "对账完结");


    private final Integer batchState;

    private final String desc;


    public static AbcBillTaskEnum getEnumByBatchState(Integer batchState) {
        for (AbcBillTaskEnum taskEnum : values()) {
            if (Objects.equals(taskEnum.getBatchState(), batchState)) {
                return taskEnum;
            }
        }
        return null;
    }
}
