package cn.com.duiba.quanyi.center.api.enums.demand;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 更换sku的对象类型枚举
 * @author yinjiaqi
 * @date 2025-02-17 09:56:28
 */
@Getter
@AllArgsConstructor
public enum ChangeSkuTypeEnum {
    /**
     * 1-tb_activity_prize
     */
    TB_ACTIVITY_PRIZE(1),
    /**
     * 2-tb_goods_pkg_sku
     */
    TB_GOODS_PKG_SKU(2),
    /**
     * 3-需求商品
     */
    TB_DEMAND_GOODS(3),
    ;
    private final Integer type;

    public static ChangeSkuTypeEnum getByType(Integer type) {
        for (ChangeSkuTypeEnum value : ChangeSkuTypeEnum.values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
