package cn.com.duiba.quanyi.center.api.enums.settlement;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2024/12/6 14:46
 */
@AllArgsConstructor
@Getter
public enum SettlementStatDataBuildTypeEnum {
    WX(1, "微信"),
    ALIPAY(2, "支付宝"),
    ALIPAY_COIN(3, "支付宝数币"),
    OBJECT(4, "实物"),
    CARD_SECRET(5, "卡密"),
    ADVANCE_PAYMENT(6, "垫资"),
    OTHER(7, "排除实物、微信立减金、支付宝立减金、支付宝数币、卡密、垫资")
    ;

    private final Integer type;
    
    private final String desc;
    
    private static final Map<Integer, SettlementStatDataBuildTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(SettlementStatDataBuildTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举值获取枚举
     * @param type 枚举值
     * @return 枚举
     */
    public static SettlementStatDataBuildTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
