package cn.com.duiba.quanyi.center.api.param.api;

import lombok.Data;

import java.io.Serializable;

/**
 * API供给标准下单参数
 * @author lizhi
 * @date 2023/12/4 20:29
 */
@Data
public class ApiUnbindUidParam implements Serializable {

    private static final long serialVersionUID = -4402952009826854906L;

    /**
     * API对接ID
     */
    private Long apiJointId;

    /**
     * 客户用户uid，uid与bindId只能传入一个，且必须传入一个
     */
    private String uid;

    /**
     * 绑定ID（微信openId/支付宝openId等，根据绑定类型确定），uid与bindId只能传入一个，且必须传入一个
     */
    private String bindId;

    /**
     * 绑定类型，必传
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiUidBindTypeEnum
     */
    private Integer bindType;
}
