package cn.com.duiba.quanyi.center.api.param.settlement.task;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * 任务与统计关系表
 * @author mybatis generator 
 * @date 2024-11-30
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SettlementStatTaskRefSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17329512198871754L;

    /**
     * 发票与结算单关联关系
     */
    private Long invoiceSettlementRefId;

    /**
     * 任务类型：1-开票，2-发票红冲，3-发票移除，4-回款认领，5-回款取消认领
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.SettlementStatTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 任务ID
     */
    private Long taskId;
}