package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementGoodsDetailDto;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementGoodsDetailSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 结算单-商品明细
 * @author kjj mybatis generator 
 * @date 2024-11-30
 */
@AdvancedFeignClient
public interface RemoteSettlementGoodsDetailService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算单-商品明细集合
     */
    List<SettlementGoodsDetailDto> selectPage(SettlementGoodsDetailSearchParam param);

    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 结算单明细集合
     */
    List<Long> selectIdPage(SettlementGoodsDetailSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(SettlementGoodsDetailSearchParam param);

    /**
     * 根据条件查询，分页，结算单详情商品页专用-根据商品id以及批次号分组
     * @param param 查询条件
     * @return 结算单-商品明细集合
     */
    List<SettlementGoodsDetailDto> selectPageGroup(SettlementGoodsDetailSearchParam param);

    /**
     * 根据条件查询，分页，结算单详情商品页专用-根据商品id以及批次号分组后总数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectGroupCount(SettlementGoodsDetailSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算单-商品明细
     */
    SettlementGoodsDetailDto selectById(Long id);

    /**
     * 批量新增
     * @param list 结算单-商品明细
     * @return key：唯一标记，value：主键
     */
    Map<String, Long> batchInsert(List<SettlementGoodsDetailDto> list);

    /**
     * 批量物理删除
     * @param ids 主键
     * @return 执行结果
     */
    int batchDelete(List<Long> ids);
}