package cn.com.duiba.quanyi.center.api.remoteservice.mall.page;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.mall.page.MallPageDetailDto;
import cn.com.duiba.quanyi.center.api.dto.mall.page.MallPageDto;
import cn.com.duiba.quanyi.center.api.dto.mall.page.MallPageRegionConfDto;
import cn.com.duiba.quanyi.center.api.param.mall.page.MallPageDetailParam;
import cn.com.duiba.quanyi.center.api.param.mall.page.MallPageSearchParam;
import java.util.List;

/**
 * 商城页面
 * @author kjj mybatis generator 
 * @date 2024-05-23
 */
@AdvancedFeignClient
public interface RemoteMallPageService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 商城页面集合
     */
    List<MallPageDto> selectPage(MallPageSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MallPageSearchParam param);


    /**
     * 新增或更新
     * @param dto 商城页面
     * @return 页面id
     */
    Long saveOrUpdate(MallPageDto dto);


    /**
     * 根据主键查询
     * @param id 主键
     * @return 商城页面
     */
    MallPageDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键集合
     * @return 商城页面
     */
    List<MallPageDto> selectByIds(List<Long> ids);

    /**
     * 新增
     * @param dto 商城页面
     * @return 执行结果
     */
    int insert(MallPageDto dto);

    /**
     * 更新
     * @param dto 商城页面
     * @return 影响行数
     */
    int update(MallPageDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 查询页面详情
     *
     * @param param 查询参数
     * @return 页面详情
     */
    MallPageDetailDto getPageDetail(MallPageDetailParam param);

    /**
     * 查询页面详情 redis缓存10min c端用
     *
     * @param param 查询参数
     * @return 页面详情
     */
    MallPageDetailDto getPageDetailWithCache(MallPageDetailParam param);

    /**
     * 编辑页面详情
     *
     * @param dto 页面详情
     * @return 编辑结果
     */
    boolean savePageDetail(MallPageDetailDto dto);

    /**
     * 更改状态
     * @param id 主键
     * @param status 状态 {@link cn.com.duiba.quanyi.center.api.enums.mall.MallStatusEnum}
     * @return 执行结果
     */
    int changeStatus(Long id, Integer status);
}