package cn.com.duiba.quanyi.center.api.dto.qy;

import cn.com.duiba.quanyi.center.api.enums.project.ProjectTechnologyTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 项目三方接口配置表
 * @author mybatis generator 
 * @date 2025-02-27
 */
@Data
public class ProjectTechnologyConfigDto implements Serializable {
     
    private static final long serialVersionUID = 17406387995761474L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 项目主键, tb_project.id
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * @see ProjectTechnologyTypeEnum
     * 0 通知接口
     */
    private Integer apiType;

    /**
     * 接口地址
     */
    private String apiUrl;

    /**
     * 操作人ID
     */
    private Long operatorId;

    /**
     * 一般为sm4密钥
     */
    private String apiSecretKey;

    /**
     * intfKey 对接ID
     */
    private Long apiJointId;

    /**
     * 接口名称
     */
    private String apiName;
}