package cn.com.duiba.quanyi.center.api.param.invoice;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 发票
 * @author mybatis generator 
 * @date 2024-12-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class InvoiceSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1733208828712220L;

    /**
     * 发票id集合
     */
    private List<Long> ids;

    /**
     * 项目ID
     */
    private List<Long> projectIds;

    /**
     * 申请人ID
     */
    private Long createOperatorId;

    /**
     * 发票抬头Id
     */
    private Long invoiceTitleId;

    /**
     * 发票抬头Id集合
     */
    private List<Long> invoiceTitleIdList;

    /**
     * 开票类型
     */
    private Integer invoiceType;

    /**
     * 开票摘要
     */
    private String invoiceSummary;

    /**
     * 发票状态：1-待开票，2-已开票，3-已红冲，4-已移除
     */
    private Integer invoiceStatus;

    /**
     * 发票号
     */
    private String invoiceNum;

    /**
     * 发票号集合
     */
    private List<String> invoiceNumList;

    /**
     * 开票开始时间
     */
    private Date invoiceIssueStartTime;

    /**
     * 开票结束时间
     */
    private Date invoiceIssueEndTime;

    /**
     * 开票申请ID
     */
    private Long invoiceApplyId;

    /**
     * 客户id, tb_partner.id
     */
    private Long partnerId;

    /**
     * 发票回款状态
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.InvoiceReceivedStatusEnum
     */
    private Integer invoiceReceivedStatus;

    /**
     * 发票是否在列表展示 0-不展示(对应开票申请状态3,9) ，1-展示(对应开票申请状态1,2,4,5,6,7,8)
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.InvoiceApplyStatusEnum
     */
    private Integer invoiceShowFlag;

    /**
     * 发票金额
     */
    private Long invoiceAmount;

    public void setProjectId(Long projectId) {
        if (projectId == null) {
            return;
        }
        if (this.projectIds == null) {
            this.projectIds = Lists.newArrayList(projectId);
        }
        this.projectIds.add(projectId);
    }
}