package cn.com.duiba.quanyi.center.api.param.payment;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;

/**
 * 打款明细表
 * @author mybatis generator 
 * @date 2024-06-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class PaymentDetailSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 1718786587401727L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 打款查询开始日期
     */
    private Date paymentDateQueryStartDate;

    /**
     * 打款查询结束日期
     */
    private Date paymentDateQueryEndDate;

    /**
     * 打款金额：两位小数点，必填
     */
    private Long paymentAmount;

    /**
     * 商品类型：整型，必填
     */
    private Integer spuType;

    /**
     * 批次号
     */
    private List<String> stockIdList;

    /**
     * 账单开始日期
     */
    private LocalDate startDate;

    /**
     * 账单结束日期
     */
    private LocalDate endDate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 最后一个主键ID
     */
    private Long lastId;
}