package cn.com.duiba.quanyi.center.api.param.wx;

import cn.com.duiba.quanyi.center.api.param.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 微信核销数据电子凭证表
 * @author mybatis generator 
 * @date 2024-06-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class WxWriteOffElectronicCertificateSearchParam extends PageQuery implements Serializable {
     
    private static final long serialVersionUID = 17187863566914349L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 批次号
     */
    private String stockId;

    /**
     * 核销金额
     */
    private Long verifiedAmount;

    /**
     * 退款金额
     */
    private Long refundAmount;

    /**
     * 核销笔数
     */
    private Integer verifiedCount;

    /**
     * 退款笔数
     */
    private Integer refundCount;

    /**
     * 记录日期
     */
    private LocalDate recordDate;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}