package cn.com.duiba.quanyi.center.api.enums.coupon;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 美团券批次状态
 * 1-编辑中
 * 2-待审核
 * 3-待提交
 * 4-审核驳回
 * 5-进行中
 * 6-已结束
 * 7-已停用
 * 8-创建失败
 */
@Getter
@AllArgsConstructor
public enum MeiTuanBatchStatusEnum {
    EDITING(1, "编辑中"),
    PENDING_APPROVAL(2, "待审核"),
    READY_TO_SUBMIT(3, "待提交"),
    REVIEW_REJECTED(4, "审核驳回"),
    IN_PROGRESS(5, "进行中"),
    COMPLETED(6, "已结束"),
    DISABLED(7, "已停用"),
    CREATION_FAILED(8, "创建失败"),
    ;

    private int code;
    private String description;

    /**
     * 根据code获取枚举对象
     * @param code
     * @return
     */
    public static MeiTuanBatchStatusEnum getByCode(int code) {
        for (MeiTuanBatchStatusEnum status : values()) {
            if (status.code == code) {
                return status;
            }
        }
        return null;
    }


}
