package cn.com.duiba.quanyi.center.api.remoteservice.bill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;


/**
 * @author wangyong
 * @date 2019/03/06
 */
@AdvancedFeignClient
public interface RemoteThirdBillService {

    /**
     * 手动触发微信未结束的账单任务
     *
     */
    Boolean manualTrigWxNotEndedBillJob();

    /**
     * 手动触发微信结束账单同步任务
     */
    Boolean manualTrigWxEndedBillJob();

    /**
     * 手动同步微信账单-已结束
     * @param filePath
     * @return
     */

    Boolean wxCouponEndedBillSync(String filePath);

    /**
     * 手动同步微信账单-未结束
     * @param filePath
     * @return
     */
    Boolean wxCouponNotEndedBillSync(String filePath);


    /**
     * 支付宝账单下载
     */
    String alipayBillDownload(List<Long> ids);




}
