package cn.com.duiba.quanyi.center.api.remoteservice.settlement.stat;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.holo.SettlementHoloGoodsDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.holo.SettlementHoloStockDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.SettlementOrderStatDayDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.SettlementOrderStatDayFillDto;
import cn.com.duiba.quanyi.center.api.dto.settlement.stat.SettlementOrderStatDaySimpleDto;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloGoodsParam;
import cn.com.duiba.quanyi.center.api.param.settlement.holo.SettlementHoloPreviewParam;
import cn.com.duiba.quanyi.center.api.param.settlement.stat.SettlementOrderStatDayAmountParam;
import cn.com.duiba.quanyi.center.api.param.settlement.stat.SettlementOrderStatDayFillSearchParam;
import cn.com.duiba.quanyi.center.api.param.settlement.stat.SettlementOrderStatDayLockParam;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 结算订单统计-日纬度
 * @author kjj mybatis generator 
 * @date 2024-11-26
 */
@AdvancedFeignClient
public interface RemoteSettlementOrderStatDayService {

    /**
     * 根据主键批量查询
     * @param ids 主键ID
     * @return 结算订单统计-日纬度
     */
    List<SettlementOrderStatDaySimpleDto> selectSimpleByIds(List<Long> ids);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 结算订单统计-日纬度
     */
    SettlementOrderStatDayDto selectById(Long id);

    /**
     * 批量锁定
     * @param list 锁定参数
     * @return 是否成功
     */
    boolean batchLock(List<SettlementOrderStatDayLockParam> list);

    /**
     * 批量解锁
     * @param settlementId 结算单ID
     * @param ids 主键
     * @return 是否成功
     */
    boolean batchUnlock(Long settlementId, List<Long> ids);

    /**
     * 分页查询结算单统计数据
     * @param param 分页参数
     * @return 结算订单统计-日纬度-回填金额
     */
    List<SettlementOrderStatDayFillDto> selectFillPage(SettlementOrderStatDayFillSearchParam param);

    /**
     * 根据ID批量查询
     * @param ids 主键
     * @return 结算订单统计-日纬度-回填金额
     */
    List<SettlementOrderStatDayFillDto> selectFillByIds(List<Long> ids);

    /**
     * 批量回填开票金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillInvoicedAmount(List<SettlementOrderStatDayAmountParam> list);

    /**
     * 批量回填回款金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillReceivedAmount(List<SettlementOrderStatDayAmountParam> list);

    /**
     * 根据条件分页查询
     * @param param
     * @return
     */
    List<SettlementHoloGoodsDto> selectGroupByDemandGoodsId(SettlementHoloGoodsParam param);

    /**
     * 根据条件查询总行数
     * @param param
     * @return
     */
    long selectCountGroupByDemandGoodsId(SettlementHoloGoodsParam param);

    /**
     * 查询预计金额记录
     * @param param
     * @return
     */
    List<SettlementOrderStatDayDto> selectExpectedAmountRecord(SettlementHoloPreviewParam param);


    /**
     * 根据demandGoodsId和stockId查询
     * @param param
     * @return
     */
    List<SettlementHoloStockDto> selectGroupByDemandGoodIdAndStockId(SettlementHoloGoodsParam param);

    /**
     * 查询累计超过期望金额记录
     * @param param
     * @return
     */
    SettlementOrderStatDayDto selectExpectedAmountRecordMore(SettlementHoloPreviewParam param);


    /**
     * 根据主键查询
     * @param ids 主键
     * @return 结算订单统计-日纬度
     */
    List<SettlementOrderStatDayDto> selectByIds(List<Long> ids);

    /**
     * 常规结算临时表
     * @param param
     * @return
     */
    void selectReceivableAmountRecord(SettlementHoloPreviewParam param);

    /**
     * 根据库存ID和锁定状态查询
     * @param stockId 库存ID
     * @param lockStatus 锁定状态
     * @return
     */
    List<SettlementOrderStatDayDto> selectByStockIdAndLockStatus(String stockId, int lockStatus);

    /**
     * 根据条件查询下载附件
     * @param uniqueMarkList
     * @param startDate
     * @param endDate
     * @return
     */
    List<String> selectPaymentAttachment(List<String> uniqueMarkList, Date startDate, Date endDate);

    /**
     * 根据条件查询该时间段的是否有包含不结算的uniqueMark
     * @param uniqueMarkList
     * @param startDate
     * @param endDate
     * @return
     */
    List<String> selectNotSettlementUniqueMarkList(List<String> uniqueMarkList, Date startDate, Date endDate);

    /**
     * 查询累计超过期望金额记录-新版用于内存计算
     * @param param
     * @return
     */
    SettlementOrderStatDayDto selectExpectedAmountNewRecordMore(SettlementHoloPreviewParam param);


    /**
     * 查询预计金额记录-新版用于内存计算
     * @param param
     * @return
     */
    List<SettlementOrderStatDayDto> selectExpectedAmountNewRecord(SettlementHoloPreviewParam param);

    /**
     * 根据条件查询锁定状态为1的uniqueMark
     * @param uniqueMarkList
     * @param startDate
     * @param endDate
     * @param lastId
     * @param pageSize
     * @return
     */
    List<SettlementOrderStatDayDto> selectLockUniqueMarkByStatDate(List<String> uniqueMarkList, Date startDate, Date endDate, Long lastId, Integer pageSize);

    /**
     * 根据条件查询更新明细
     * @param param
     * @return
     */
    List<SettlementOrderStatDayDto> selectDetailByParam(SettlementHoloGoodsParam param);

    /**
     * 批量更新
     * @param updateList
     * @return
     */
    int batchUpdate(List<SettlementOrderStatDayDto> updateList);
}