package cn.com.duiba.quanyi.center.api.param.api;

import cn.com.duiba.quanyi.center.api.enums.BooleanEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * API供给标准下单参数
 * 
 * @author lizhi
 * @date 2023/12/4 20:29
 */
@Data
public class ApiCreateOrderParam implements Serializable {

    private static final long serialVersionUID = -4402952009826854906L;

    /**
     * API对接ID
     */
    private Long apiJointId;

    /**
     * 商品ID
     */
    private Long specId;

    /**
     * 商品类型
     *
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiSpecTypeEnum
     */
    private Integer specType;

    /**
     * 客户单号
     */
    private String thirdOrderId;

    /**
     * 下单结果、状态变更通知url
     */
    private String notifyUrl;

    /**
     * 回调通知mq topic
     */
    private String notifyMqTopic;

    /**
     * 同步结果mq topic
     */
    private String syncMqTopic;

    /**
     * 开发者自有参数，兑吧透传
     */
    private String remark;

    /**
     * 业务主体
     * 
     * @see cn.com.duiba.quanyi.goods.service.api.enums.subject.SubjectEnum
     */
    private Integer duibaSubject;

    /**
     * appId
     */
    private String appId;

    /**
     * 用户ID（API活动时有值）
     */
    private Long userId;

    /**
     * 客户用户uid
     */
    private String uid;

    /**
     * 绑定类型
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiUidBindTypeEnum
     */
    private Integer bindType;

    /**
     * 订单类型
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiOrderTypeEnum
     */
    private Integer orderType;

    /**
     * 商品数量
     */
    private Integer quantity;

    /**
     * 指定面额发券，面额
     * 说明：定面额发券场景，券面额，其他场景不需要填，单位：分。
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponValue;

    /**
     * 指定面额发券，券门槛
     * 说明：指定面额发券批次门槛，其他场景不需要，单位：分。
     * 校验规则：仅在发券时指定面额及门槛的场景才生效，常规发券场景请勿传入该信息。
     * 选填
     */
    private Integer couponMinimum;

    /**
     * 微信用户openId
     */
    private String wxOpenId;

    /**
     * 微信公众号、小程序AppID
     */
    private String wxAppId;

    /**
     * 支付宝用户id，可通过支付宝授权方式获取
     */
    private String alipayUserId;

    /**
     * 支付宝登录账号，邮箱格式
     */
    private String alipayLoginId;

    /**
     * 支付宝登录账号，手机号格式
     */
    private String alipayPhoneId;

    /**
     * 支付宝用户openid
     */
    private String alipayOpenId;

    /**
     * 支付宝立减金: 指定主体appid
     */
    private String specifyAppId;

    /**
     * 支付宝立减金: 用户在指定主体的openid
     */
    private String specifyOpenId;

    /**
     * 充值手机号
     * ● 商品为银行卡转账时，必填
     */
    private String phone;

    /**
     * 充值账号
     * ● 商品为油卡时有值
     * ● 商品为银行卡转账时为银行卡号，必填
     */
    private String account;

    /**
     * 充值qq号
     */
    private String qqAccount;

    /**
     * 用户真实姓名
     * ● 商品为微信到零钱时，可选，若填值，会校验openId与该姓名是否一致
     */
    private String realName;

    /**
     * 转账金额，单位：分
     * ● 商品为微信到零钱，且为不定额时必填
     * ● 商品为微信红包时，且为不定额时必填
     * ● 商品为银行卡转账时，且为不定额时必填
     */
    private Long transferAmount;

    /**
     * 转账备注
     * ● 商品为微信到零钱时，必填
     * ● 商品为微信红包时，为活动名称，必填
     * ● 商品为银行卡转账时，为转账备注，必填
     */
    private String transferRemark;

    /**
     * 商户名称
     * ● 商品为微信红包时，必填
     */
    private String redpackBusiness;

    /**
     * 红包祝福语
     * ● 商品为微信红包时，必填
     */
    private String redpackBlessings;

    /**
     * 是否同步请求
     *
     * @see cn.com.duiba.quanyi.center.api.enums.BooleanEnum
     */
    private Integer syncReq;

    /**
     * 券包推送类型
     * 
     * @see cn.com.duiba.quanyi.center.api.enums.api.ApiPkgPushTypeEnum
     */
    private Integer pkgPushType;

    /**
     * 签名
     * ● 目前只有京东会用到该字段
     */
    private String sign;

    /**
     * 验证码
     * ● 目前只有京东会用到该字段
     */
    private String code;

    /**
     * 收货人姓名
     * ● 商品为银行卡转账时，必填
     */
    private String name;

    /**
     * 收货地址 省份
     */
    private String province;

    /**
     * 收货地址 市
     */
    private String city;

    /**
     * 收货地址 区、县
     */
    private String district;

    /**
     * 收货地址 街道
     */
    private String street;

    /**
     * 收货详细地址
     */
    private String address;

    /**
     * 身份证
     * ● 商品为银行卡转账时，必填
     */
    private String idCard;

    /**
     * 权益券是否限制手机号
     */
    private Integer equityLimitPhone;

    /**
     * 权益券是否限制车牌号
     */
    private Integer equityLimitCarNumber;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 1 需要过期推送 0 不需要非必填
     * 
     * @see BooleanEnum
     */
    private Integer shortUrlExpireType;

    /**
     * 内部业务参数，json格式
     */
    private ApiCreateOrderBizJsonParam bizJsonParam;
}
