package cn.com.duiba.quanyi.center.api.dto.coupon;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 支付宝活动资金流水
 * @author mybatis generator 
 * @date 2025-01-16
 */
@Data
public class AlipayActivityFundFlowDto implements Serializable {
     
    private static final long serialVersionUID = 17370115839397473L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 支付宝活动id
     */
    private String activityId;

    /**
     * 记账日期 yyyy-mm-dd
     */
    private LocalDate curDate;

    /**
     * 收支类型 1-支出 2-收入
     */
    private Integer changeType;

    /**
     * 收支金额 分
     */
    private Long changeAmount;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}