package cn.com.duiba.quanyi.center.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 上传任务业务类型
 * @author lizhi
 * @date 2023/3/29 2:13 PM
 */
@Getter
@AllArgsConstructor
public enum UploadBizTypeEnum {
    ACTIVITY_WHITE_LIST_ADD(1, "上传活动白名单"),
    ACTIVITY_STAFF_ADD(2, "上传活动客户经理"),
    ACTIVITY_PRIZE_USER_CONF_ADD(3, "上传活动奖项白名单"),
    CARD_SECRET_COUPON_CODE_ADD(4, "上传卡劵-劵码"),
    CARD_SECRET_COUPON_LINK_CODE_ADD(5, "上传卡劵-链接劵"),
    CARD_SECRET_COUPON_ACCOUNT_ADD(6, "上传卡劵-账号密码"),
    ICBC_SX_WRITE_OFF_ADD(7, "山西工行核销导入"),
    CCB_BUSINESS_IMPORT(8, "建行商户导入"),
    CCB_LN_SETTLEMENT_IMPORT(9, "辽宁建行结算明细导入"),
    INSURANCE_AGENT_IMPORT(10, "保司坐席导入"),
    INSURANCE_EQUITY_IMPORT(11, "保司车险权益导入"),
    INSURANCE_EQUITY_VERITY_IMPORT(12, "保单验真导入"),
    INSURANCE_EQUITY_HISTORY_IMPORT(13, "保单权益历史数据迁移导入"),
    ICBC_STORE_IMPORT(14, "工行门店导入"),
    COUPON_BANK_UPLOAD(15, "自动创建批次-银行立减金"),
    INSURANCE_RENBAO_EQUITY_IMPORT(16, "人保保司车险权益导入"),
    GOODS_ORDER_OBJECT_SHIP(17, "批量发货"),
    INSURANCE_NON_CAR_EQUITY_IMPORT(18, "保司非车权益导入"),
    INSURANCE_NON_CAR_RENBAO_EQUITY_IMPORT(19, "人保保司非车权益导入"),
    WX_COUPON_BILL_PULL(20, "微信账单拉取"),
    COUPON_FULL_UPLOAD(21, "自动创建微信立减金-全场代金券"),
    ICBC_SX_ACTIVITY_ADD(22, "山西工行活动导入"),
    INSURANCE_YUNYAN_EQUITY_IMPORT(23, "贵州云岩保司车险权益导入"),
    CASHIER_CUT_FULL_CUT_UPLOAD(24, "自动创建微信立减金-收银台全场立减"),
    CASHIER_CUT_FULL_DISCOUNT_UPLOAD(25, "自动创建微信立减金-收银台全场折扣"),
    CASHIER_DIRECT_CUT_UPLOAD(26, "自动创建微信立减金-收银台定向立减"),
    INSURANCE_CHANGSHA_EQUITY_IMPORT(27, "长沙保司车险权益导入"),
    PAYMENT_DETAIL_IMPORT(28, "打款明细上传"),
    WX_COUPON_UPLOAD_UPDATE(29, "微信立减金撒上传更新"),
    ACTIVITY_TEMPLATE_WHITE_IMPORT(31, "模板活动白名客户号单倒入"),
    WX_COUPON_MODIFY_AMOUNT_UPLOAD(32, "微信立减金批量修改金额导入"),
    INSURANCE_LAND_IMPORT(30, "大地保险权益导入"),
    ALIPAY_CARD_PAY_CUT_UPLOAD(33, "自动创建支付宝立减金-银行卡支付立减"),
    ALIPAY_GENERAL_COUPON_UPLOAD(34, "自动创建支付宝立减金-通用渠道红包"),
    ALIPAY_FIRST_BIND_UPLOAD(35, "自动创建支付宝立减金-首绑有礼"),
    ALIPAY_MANY_CARD_SWIPING_UPLOAD(36, "自动创建支付宝立减金-银行卡支付立减"),
    ACTIVITY_TEMPLATE_BASE_WHITE_IMPORT(37, "模板活动基础白名客户号单倒入"),
    BATCH_STOCK_UPLOAD_UPDATE(38, "批次号批量分配处理批次"),
    INSURANCE_EQUITY_CAR_SER_UPLOAD(39, "车服权益导入"),
    INSURANCE_BLACKLIST_UPLOAD(40, "保司黑名单导入"),
    ALIPAY_COUPON_UPLOAD_UPDATE(41, "支付宝立减金上传更新"),
    ALIPAY_ACTIVITY_UPLOAD(42, "自动创建支付宝活动"),
    INSURANCE_CHENGDUTAIBAO_EQUITY_IMPORT(43, "成都太保保司车险权益导入"),
    WX_COUPON_FIRST_BIND_UPLOAD(44, "自动创建微信立减金-首绑有礼"),
    PROJECT_GOODS_UPLOAD(45, "项目商品-批量导入"),
    CCB_HZ_SETTLEMENT_IMPORT(46, "杭州建行结算明细导入"),
    CCB_HZ_PAYMENT_IMPORT(47, "杭州建行打款记录明细导入"),
    EXTERNAL_ORDER_IMPORT(48, "外部订单导入"),
    RECEIVED_PAYMENT_IMPORT(49, "回款导入"),
    EXTERNAL_WX_STOCK_BILL_STOPED(50, "外部微信批次结束账单"),
    INVOICE_UPLOAD(54, "批量上传发票"),
    WX_MCH_CODE_GROUP_UPLOAD(55, "商户号组上传"),
    ABC_BANK_AMOUNT_PUSH_IMPORT(56, "农总行银行金额导入"),
    ABC_BANK_AGAIN_PUSH_IMPORT(57, "农总行批量重推"),
    INVOICE_HISTORY_UPLOAD(58, "批量上传历史发票"),
    INVOICE_HISTORY_UPLOAD_DEMAND(59, "批量上传历史发票（需求维度）"),
    INVOICE_HISTORY_UPLOAD_CONTACTS(60, "批量上传历史发票（对接人维度）"),
    INSURANCE_WUHAN_EQUITY_IMPORT(61, "武汉保司车险权益导入"),
    BATCH_CLOSE_INNER_ORDER(62, "内部订单-批量关单"),
    INSURANCE_HARBIN_EQUITY_IMPORT(64, "哈尔滨保司车险权益导入"),
    CCB_HSQ_WRITE_OFF_PUSH(65, "建行惠省钱核销推送"),
    RECEIVED_BATCH_ASSOCIATION_INVOICE(66, "回款表批量关联发票"),
    CREDIT_MALL_CREDITS_IMPORT_ADD(71, "积分商城积分导入(加积分)"),
    CREDIT_MALL_CREDITS_IMPORT_SUB(72, "积分商城积分导入(扣积分)"),
    EXTERNAL_ORDER_CONVERT(73, "外部订单格式转换"),
    PROJECT_GROSS_MARGIN_IMPORT(74, "项目品类毛利率"),
    REPAYMENT_SUBJECT_INVOICE(79, "导入回款主体关联发票"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
