package cn.com.duiba.quanyi.center.api.param;

import java.io.Serializable;
import java.util.Objects;

public class PageQuery implements Serializable {
    private static final long serialVersionUID = -4871219675854907829L;

    private Integer pageIndex = 1;

    /**
     * 单次查询不建议超过2000
     */
    private Integer pageSize = 20;

    public Integer getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getOffset() {
        if (Objects.nonNull(pageIndex) && Objects.nonNull(pageSize)) {
            return (pageIndex - 1) * pageSize;
        }
        return null;
    }
}
