package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.MeiTuanCouponDto;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanActivitySaveOrUpdateParam;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanBindDemandGoodsParam;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanCouponBatchUpdateCreatorParam;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanCouponSearchParam;
import cn.com.duiba.quanyi.center.api.param.coupon.MeiTuanUpdateDeadlineParam;

import java.util.List;
import java.util.Set;

/**
 * 美团支付劵表
 * @author kjj mybatis generator 
 * @date 2024-09-14
 */
@AdvancedFeignClient
public interface RemoteMeiTuanCouponService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 美团支付劵集合
     */
    List<MeiTuanCouponDto> selectPage(MeiTuanCouponSearchParam param);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 美团支付劵集合
     */
    List<MeiTuanCouponDto> selectNoPage(MeiTuanCouponSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(MeiTuanCouponSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 美团支付劵
     */
    MeiTuanCouponDto selectById(Long id);

    /**
     * 新增
     * @param dto 美团支付劵
     * @return 执行结果
     */
    int insert(MeiTuanCouponDto dto);

    /**
     * 更新
     * @param dto 美团支付劵
     * @return 影响行数
     */
    int update(MeiTuanCouponDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 新增或修改
     *
     * @param param
     * @return
     */
    Long saveOrUpdate(MeiTuanActivitySaveOrUpdateParam param);

    /**
     * 批量替换创建人
     *
     * @param param 参数
     * @return 影响行数
     */
    int batchUpdateCreator(MeiTuanCouponBatchUpdateCreatorParam param);

    /**
     * 批次启用停用
     *
     * @param id 主键
     * @return 执行结果
     */
    int updateEnableStatus(Long id,Integer enableStatus);


    /**
     * 根据创建人查询记录总数
     *
     * @param createOperatorId 创建人
     * @return 记录总数
     */
    int selectCreatorCount(Long createOperatorId);
    /**
     * 根据需求商品id和skuId查询
     *
     * @param demandGoodsId 需求商品id
     * @param skuId skuId
     * @return 美团支付劵
     */
    List<MeiTuanCouponDto> selectByDemandGoodsIdSkuId(Long demandGoodsId, Long skuId);

    /**
     * 根据需求id和skuId查询
     *
     * @param demandId 需求id
     * @param skuId skuId
     * @return 美团支付劵
     */

    List<MeiTuanCouponDto> selectByDemandSkuId(Long demandId, Long skuId);

    /**
     * 根据主键查询
     *
     * @param ids 主键集合
     * @return 美团支付劵集合
     */
    List<MeiTuanCouponDto> selectByIdList(Set<Long> ids);

    /**
     * 根据需求商品id查询
     *
     * @param demandGoodsId 需求商品id
     * @return 美团支付劵集合
     */
    List<MeiTuanCouponDto> findByDemandGoodsId(Long demandGoodsId);

    /**
     * 根据需求ID批量查询
     * @param demandIds 需求ID集合
     * @return 美团支付劵集合
     */
    List<Long> findCouponIdsByDemandIds(List<Long> demandIds);

    /**
     * 批量绑定需求商品
     *
     * @param convertCouponBindParamList 绑定参数集合
     * @return 影响行数
     */
    int batchBindDemandGoods(List<MeiTuanBindDemandGoodsParam> convertCouponBindParamList);

    /**
     * 单个绑定需求商品
     *
     * @param convertCouponBindParam 绑定参数
     * @return 影响行数
     */
    int bindDemandGoods(MeiTuanBindDemandGoodsParam convertCouponBindParam);

    /**
     * 批量解绑需求商品
     *
     * @param ids 解绑券集合
     * @param demandGoodsId 需求商品id
     * @return 影响行数
     */
    int batchUnbindDemandGoods(List<Long> ids, Long demandGoodsId);

    /**
     * 解绑需求商品
     *
     * @param id 解绑券id
     * @return
     */
    boolean cancelAssociation(Long id);

    /**
     * 根据批次号ID更新结算天数
     * @param couponIdList 批次id集合
     * @param settlementDeadlineDays 退款结算日天数
     * @return 影响条数
     */
    int updateSettlementDeadlineDaysByIds(List<Long> couponIdList, Integer settlementDeadlineDays);

    /**
     * 根据批次号ID更新结算天数
     * @param param 更新参数
     * @return 影响条数
     */
    int updateSettlementDeadlineByParam(MeiTuanUpdateDeadlineParam param);
}