package cn.com.duiba.quanyi.center.api.remoteservice.qystatistic.bank.zgbank;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qystatistic.ZgBankClrpBillDiDto;
import cn.com.duiba.quanyi.center.api.param.bank.zgbank.ZgBankClrpBillDiSearchParam;
import java.util.List;

/**
 * 中国银行CLRP账单明细表
 * @author kjj mybatis generator 
 * @date 2025-02-17
 */
@AdvancedFeignClient
public interface RemoteZgBankClrpBillDiService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 中国银行CLRP账单明细集合
     */
    List<ZgBankClrpBillDiDto> selectPage(ZgBankClrpBillDiSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ZgBankClrpBillDiSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 中国银行CLRP账单明细
     */
    ZgBankClrpBillDiDto selectById(Long id);

    /**
     * 新增
     * @param dto 中国银行CLRP账单明细
     * @return 执行结果
     */
    int insert(ZgBankClrpBillDiDto dto);

    /**
     * 更新
     * @param dto 中国银行CLRP账单明细
     * @return 影响行数
     */
    int update(ZgBankClrpBillDiDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}