package cn.com.duiba.quanyi.center.api.remoteservice.unionpay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.unionpay.UnionPayActivityRelationDto;
import cn.com.duiba.quanyi.center.api.param.unionpay.UnionPayActivityRelationSearchParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 银联卡卷活动关联表
 * @author kjj mybatis generator 
 * @date 2025-04-23
 */
@AdvancedFeignClient
public interface RemoteUnionPayActivityRelationService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 银联卡卷活动关联集合
     */
    List<UnionPayActivityRelationDto> selectPage(UnionPayActivityRelationSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(UnionPayActivityRelationSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 银联卡卷活动关联
     */
    UnionPayActivityRelationDto selectById(Long id);

    /**
     * 新增
     * @param dto 银联卡卷活动关联
     * @return 执行结果
     */
    int insert(UnionPayActivityRelationDto dto);

    /**
     * 更新
     * @param dto 银联卡卷活动关联
     * @return 影响行数
     */
    int update(UnionPayActivityRelationDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量查询批次关联活动数量
     * @param couponIds 批次ID列表
     * @return key：批次ID，value：关联活动数量
     */
    Map<Long, Integer> selectActivityCountMapByCouponIds(Set<Long> couponIds);

    /**
     * 通过奖励ID 和活动类型批量查询
     * @param prizeId
     * @param activityType
     * @return
     */
    List<UnionPayActivityRelationDto> selectByActivityPrizeId(Long prizeId, Integer activityType);

    /**
     * 通过奖品ID 批量查询
     * @param prizeIds
     * @param activityType
     * @return
     */
    List<UnionPayActivityRelationDto> selectByActivityPrizeIds(List<Long> prizeIds, Integer activityType);


    /**
     * 通银联支付劵 主键ID 批量查询
     * @param unionPayCouponIds
     * @return
     */
    List<UnionPayActivityRelationDto> selectByUnionPayCouponIds(Set<Long> unionPayCouponIds);

    /**
     * 批量插入关联关系
     * @param list
     * @return 插入结果
     */
    int batchInsert(List<UnionPayActivityRelationDto> list);


    /**
     * 批量删除绑定关系
     * @param ids 主键ID
     * @return
     */
    int batchDelete(List<Long> ids);
}