package cn.com.duiba.quanyi.center.api.dto.insurance.equity;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 保司权益保单表
 * @author mybatis generator 
 * @date 2024-03-04
 */
@Data
public class InsuranceEquityPolicyDto implements Serializable {
     
    private static final long serialVersionUID = 17095322687051368L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 是否逻辑删除, 0-未删除, 1-已删除
     * @see cn.com.duiba.quanyi.center.api.enums.LogicDeleteEnum
     */
    private Integer logicDelete;

    /**
     * 删除时间
     */
    private Date logicDeleteTime;

    /**
     * 权益ID，tb_insurance_equity.id
     */
    private Long insuranceEquityId;

    /**
     * 保单号
     */
    private String policyNo;

    /**
     * 保单类型，1-车险，2-非车
     * @see cn.com.duiba.quanyi.center.api.enums.insurance.InsurancePolicyTypeEnum
     */
    private Integer policyType;

    /**
     * 客户手机号
     */
    private String customerPhone;

    /**
     * 车牌号
     */
    private String carNumber;

    /**
     * 保险费，单位分
     */
    private Long policyAmount;

    /**
     * 权益费，单位分
     */
    private Long equityAmount;

    /**
     * 身份证
     */
    private String identityCard;
}