package cn.com.duiba.quanyi.center.api.remoteservice.coupon;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.coupon.AlipayActivityAutoCreateTaskDto;
import cn.com.duiba.quanyi.center.api.param.coupon.notify.AlipayActivityCreateResultNotifyParam;
import cn.com.duiba.quanyi.center.api.param.coupon.notify.AlipayActivityPublishResultNotifyParam;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/7/25 16:54
 **/
@AdvancedFeignClient
public interface RemoteAlipayActivityAutoCreateService {

    /**
     * 批量初始化支付宝活动创建任务
     *
     * @param activityType 活动类型 {@link cn.com.duiba.quanyi.center.api.enums.coupon.AlipayActivityTypeEnum}
     * @param list 支付宝活动
     * @return 创建任务结果
     * @throws BizException 异常
     */
    boolean batchInit(Integer activityType, List<AlipayActivityAutoCreateTaskDto> list) throws BizException;

    /**
     * 支付宝活动创建结果通知
     *
     * @param params 支付宝活动创建结果通知
     * @return 通知结果
     * @throws BizException 异常
     */
    boolean createResultNotify(List<AlipayActivityCreateResultNotifyParam> params) throws BizException;

    /**
     * 支付宝活动发布结果通知
     *
     * @param params 支付宝活动发布结果通知
     * @return 通知结果
     * @throws BizException 异常
     */
    boolean publishResultNotify(List<AlipayActivityPublishResultNotifyParam> params) throws BizException;
}
