package cn.com.duiba.quanyi.center.api.remoteservice.qy.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.qy.activity.ActivityTemplatePrizeStockDto;
import cn.com.duiba.quanyi.center.api.param.qy.activity.ActivityTemplatePrizeStockSearchParam;
import java.util.List;

/**
 * 活动模板奖品不定额库存表
 * @author kjj mybatis generator 
 * @date 2025-01-23
 */
@AdvancedFeignClient
public interface RemoteActivityTemplatePrizeStockService {
     
    /**
     * 根据条件查询，分页，管理后端列表查询专用
     * @param param 查询条件
     * @return 活动模板奖品不定额库存集合
     */
    List<ActivityTemplatePrizeStockDto> selectPage(ActivityTemplatePrizeStockSearchParam param);

    /**
     * 不分页
     * @param param
     * @return
     */
    List<ActivityTemplatePrizeStockDto> selectList(ActivityTemplatePrizeStockSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(ActivityTemplatePrizeStockSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 活动模板奖品不定额库存
     */
    ActivityTemplatePrizeStockDto selectById(Long id);

    /**
     * 新增
     * @param dto 活动模板奖品不定额库存
     * @return 执行结果
     */
    int insert(ActivityTemplatePrizeStockDto dto);

    /**
     * 更新
     * @param dto 活动模板奖品不定额库存
     * @return 影响行数
     */
    int update(ActivityTemplatePrizeStockDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    /**
     * 批量更新库存
     * @param stockDtoList
     * @return
     */
    Boolean batchUpdateStock(List<ActivityTemplatePrizeStockDto> stockDtoList);



}