package cn.com.duiba.quanyi.center.api.bean.inner;

import cn.com.duiba.quanyi.center.api.enums.inner.InnerLogTypeEnum;
import lombok.Getter;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Calendar;

/**
 * 权益inner日志
 *
 * @author zzy
 * @date 2023/12/14  15:44
 */
@Getter
public class InnerLogBean<T> {

    /**
     * 权益固定21
     */
    private final Integer group = 21;

    private final Integer type;

    private final String time;

    private final T json;

    public InnerLogBean(InnerLogTypeEnum typeEnum, T json) {
        this.type = typeEnum.getType();
        this.time = DateFormatUtils.format(Calendar.getInstance(), "yyyy-MM-dd HH:mm:ss");
        this.json = json;
    }
}
