package cn.com.duiba.quanyi.center.api.enums.contract;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 合同金额类型
 * 1.新购、2.增购、3.续费、4.无
 */
@Getter
@AllArgsConstructor
public enum ContractCooperationTypeEnum {

    NEW(1, "新购"),
    ADD(2, "增购"),
    CONTINUE(3, "续费"),
    NOTHING(4, "无"),
    ;

    private final Integer code;

    private final String desc;

    public static String getDesc(Integer code) {
        for (ContractCooperationTypeEnum subjectEnum : ContractCooperationTypeEnum.values()) {
            if (subjectEnum.getCode().equals(code)) {
                return subjectEnum.getDesc();
            }
        }
        return null;
    }

    public static Integer getCode(String desc) {
        for (ContractCooperationTypeEnum subjectEnum : ContractCooperationTypeEnum.values()) {
            if (subjectEnum.getDesc().equals(desc)) {
                return subjectEnum.getCode();
            }
        }
        return null;
    }
}
