package cn.com.duiba.quanyi.center.api.enums.goods;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 内部订单批量关单类型枚举
 * @author yinjiaqi
 * @date 2025-02-21 11:01:34
 */
@Getter
@AllArgsConstructor
public enum GoodsOrderBatchCloseTypeEnum {
    BATCH_CLOSE_ORDER_API(1, "批量关单-api 供货订单"),
    BATCH_CLOSE_ORDER_KAMI(2, "批量关单-兑吧卡密订单"),
    BATCH_CLOSE_ORDER_ACTIVITY(3, "批量关单-活动类订单"),
    BATCH_CLOSE_ORDER_CAR(4, "批量关单-车主商城订单"),
    ;
    private static final Map<Integer, GoodsOrderBatchCloseTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values())
                    .collect(Collectors.toMap(GoodsOrderBatchCloseTypeEnum::getType, Function.identity(), (v1, v2) -> v2)));

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    public static GoodsOrderBatchCloseTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
