package cn.com.duiba.quanyi.center.api.enums.task;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 定时任务类型
 * @author lfh
 */
@Getter
@AllArgsConstructor
public enum ScheduledTaskBizTypeEnum {

    DEFAULT(0, "默认类型"),

    PRIZE_STOCK(1, "奖品库存"),
    CUSTOMIZE_PAGE_CONTENT(2, "自定义页面内容"),
    ;


    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;


    public static ScheduledTaskBizTypeEnum getByType(Integer type) {
        for (ScheduledTaskBizTypeEnum value : values()) {
            if (value.getType().equals(type)) {
                return value;
            }
        }
        return null;
    }
}
