package cn.com.duiba.quanyi.center.api.enums.workflow;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author lizhi
 * @date 2024/10/25 16:21
 */
@Getter
@AllArgsConstructor
public enum WorkflowTaskStatusEnum {
    //NEW-未启动 RUNNING-处理中 PAUSED-暂停 CANCELED-取消 COMPLETED-完成 TERMINATED-终止
    // AGREE-同意 REFUSE-拒绝 REDIRECTED-转交
    NEW(1, "未启动"),
    RUNNING(2, "处理中"),
    PAUSED(3, "暂停"),
    CANCELED(4, "取消"),
    TERMINATED(5, "终止"),
    AGREE(6, "同意"),
    REFUSE(7, "拒绝"),
    REDIRECTED(8, "转交"),
    ;
    
    private final Integer status;
    
    private final String desc;
}
