package cn.com.duiba.quanyi.center.api.param.settlement;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2024/12/2 11:25
 */
@Data
public class SettlementEditParam implements Serializable {

    private static final long serialVersionUID = 8576989338866751848L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 实际结算对接人
     */
    private Long settlementContactsId;

    /**
     * 结算单名称
     */
    private String settlementName;

    /**
     * 结算金额，单位分
     */
    private Long settlementAmount;

    /**
     * 容差备注
     */
    private String toleranceRemark;

    /**
     * 预付款使用规则：1-项目下全部对接人可用，2-指定对接人可用
     * @see cn.com.duiba.quanyi.center.api.enums.settlement.prepayment.PrepaymentUsageRulesEnum
     */
    private Integer prepaymentUsageRules;

    /**
     * 对接人ID，多个以英文逗号分隔
     */
    private String contactsIds;

    /**
     * 附件
     */
    private String settlementAttachment;

    /**
     * 操作人ssoId
     */
    private Long operatorId;
}
