package cn.com.duiba.quanyi.center.api.param.workflow;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * 活动审批流发起审批参数
 * @author xuzhigang
 * @date 2025-06-19
 */
@Data
public class ActivityWorkflowStartApprovalProcessParam implements Serializable {

    private static final long serialVersionUID = 7429385617294738521L;

    /**
     * 活动id
     */
    @NotNull(message = "活动ID不能为空")
    private Long activityId;

    /**
     * 活动类型
     * @see cn.com.duiba.quanyi.center.api.enums.activity.BizActTypeEnum#getType()
     */
    @NotNull(message = "活动类型不能为空")
    private Integer activityType;

    /**
     * 审批流类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum#getType()
     */
    @NotNull(message = "审批流类型不能为空")
    private Integer workflowType;

    /**
     * 当前用户部门ID
     */
    @NotNull(message = "部门ID不能为空")
    private Long deptId;

    /**
     * 发起人用户ID
     */
    @NotNull(message = "发起人用户ID不能为空")
    private String originatorUserId;

    /**
     * 发起人sso用户ID
     */
    @NotNull(message = "发起人sso用户ID不能为空")
    private Long initiatorSsoId;

    /**
     * 活动开发者ID
     */
    private Long activityDeveloperSsoId;

    /**
     * 活动产品经理ID
     */
    private Long activityProductManagerSsoId;
} 