package cn.com.duiba.quanyi.center.api.remoteservice.settlement;

import java.util.List;
import java.util.Set;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.settlement.SettlementDemandDetailDto;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementDemandDetailFillAmountParam;
import cn.com.duiba.quanyi.center.api.param.settlement.SettlementDemandLockOrUnlockParam;

/**
 * 结算单需求明细
 *
 * @author kjj mybatis generator
 * @date 2025-06-26
 */
@AdvancedFeignClient
public interface RemoteSettlementDemandDetailService {

    /**
     * 根据主键批量查询
     *
     * @param ids 主键集合
     * @return 结算单需求明细
     */
    List<SettlementDemandDetailDto> selectByIds(List<Long> ids);

    /**
     * 批量新增
     *
     * @param list 结算单需求明细
     * @return 执行结果
     */
    int batchInsert(List<SettlementDemandDetailDto> list);

    /**
     * 根据结算单ID查询列表
     *
     * @param settlementId 结算单ID
     * @return 结算单需求明细集合
     */
    List<SettlementDemandDetailDto> selectBySettlementId(Long settlementId);

    /**
     * 批量锁定或解锁需求明细
     * @param projectId 项目ID
     * @param lockOrUnlockParamList 锁定或解锁参数集合
     * @return 执行结果
     */
    boolean batchLockOrUnlock(Long projectId, List<SettlementDemandLockOrUnlockParam> lockOrUnlockParamList);

    /**
     * 批量回填开票金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillInvoicedAmount(List<SettlementDemandDetailFillAmountParam> list);

    /**
     * 批量回填回款金额
     * @param list 参数
     * @return 是否成功
     */
    boolean batchFillReceivedAmount(List<SettlementDemandDetailFillAmountParam> list);

}
