package cn.com.duiba.quanyi.center.api.dto.demand;

import cn.com.duiba.quanyi.center.api.enums.coupon.AmountTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/7/12 21:26
 **/
@Data
public class DemandUpdateGoodsConsumeBudgetDetailDto implements Serializable {
    private static final long serialVersionUID = -2177366616016517634L;

    /**
     * 需求商品id
     */
    private Long demandGoodsId;

    /**
     * 商品名称
     */
    private String purchaseSpuName;

    /**
     * 面额类型：1-固定，2-不固定
     * @see AmountTypeEnum#getType()
     */
    private Integer amountType;

    /**
     * 面额，单位分（固定面额时必填）
     */
    private Long amount;

    /**
     * 不固定面额：最小金额
     */
    private Long rangeMinAmount;

    /**
     * 不固定面额：最大金额
     */
    private Long rangeMaxAmount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 修改前商品数量
     */
    private Long originQuantity;

    /**
     * 商品数量
     */
    private Long quantity;

    /**
     * 修改前消耗预算
     */
    private Long originConsumeBudget;

    /**
     * 消耗预算
     */
    private Long consumeBudget;

    /**
     * 修改结果
     * true-成功 fail-失败
     */
    private Boolean result;

    /**
     * 修改失败原因
     */
    private String failMsg;
}
