package cn.com.duiba.quanyi.center.api.dto.settlement;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 结算单合同明细
 * @author mybatis generator
 * @date 2025-07-11
 */
@Data
public class SettlementContractDetailDto implements Serializable {

    private static final long serialVersionUID = 17522033088134247L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 结算单ID
     */
    private Long settlementId;

    /**
     * 合同ID
     */
    private Long contractId;

    /**
     * 应收金额
     */
    private Long receivableAmount;

    /**
     * 结算金额
     */
    private Long settlementAmount;

    /**
     * 容差金额
     */
    private Long toleranceAmount;

    /**
     * 已锁定金额
     */
    private Long lockAmount;

    /**
     * 已开票金额
     */
    private Long invoicedAmount;

    /**
     * 格式：发票ID_0_金额,发票ID_0_金额
     */
    private String invoiceIds;

    /**
     * 已回款金额
     */
    private Long receivedAmount;

    /**
     * 格式：发票ID_回款ID_金额,发票ID_回款ID_金额
     */
    private String receiveIds;
}
