package cn.com.duiba.quanyi.center.api.dto.workflow;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 审批流记录
 * @author mybatis generator
 * @date 2024-10-21
 */
@Data
public class WorkflowInstanceDto implements Serializable {

    private static final long serialVersionUID = 17294988941327804L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 业务ID
     */
    private Long bizId;

    /**
     * 审批流类型
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.WorkflowTypeEnum
     */
    private Integer workflowType;

    /**
     * 审批流实例ID
     */
    private String instanceId;

    /**
     * 审批状态
     * @see cn.com.duiba.quanyi.center.api.enums.workflow.ApprovalStatusEnum
     */
    private Integer approvalStatus;

    /**
     * 失败原因
     */
    private String errorMsg;

    /**
     * 发起人sso用户ID
     */
    private Long initiatorSsoId;

    /**
     * 发起审批时间
     */
    private Date initiationTime;

    /**
     * 扩展参数
     */
    private String extParam;
}
