package cn.com.duiba.quanyi.center.api.enums.product;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 产品类型
 * 1.标准 2.定制
 */
@Getter
@AllArgsConstructor
public enum ProductTypeEnum {

    STANDARD(1, "标准"),
    CUSTOMIZED(2, "定制"),
    ;

    private final Integer code;

    private final String desc;

    public static String getDesc(Integer code) {
        for (ProductTypeEnum subjectEnum : ProductTypeEnum.values()) {
            if (subjectEnum.getCode().equals(code)) {
                return subjectEnum.getDesc();
            }
        }
        return null;
    }
}
