package cn.com.duiba.quanyi.center.api.param.coupon;

import lombok.Data;

import java.io.Serializable;

/**
 * 支付宝立减金绑定到需求商品参数
 */
@Data
public class AlipayBindDemandGoodsParam implements Serializable {
    private static final long serialVersionUID = -6058244928260784168L;

    /**
     * tb_alipay_activity.id
     */
    private Long alipayActivityId;
    /**
     * 需求id
     */
    private Long demandId;

    /**
     * 需求商品id
     */
    private Long demandGoodsId;

    /**
     * 退款结算截止日
     */
    private Integer settlementDeadlineDays;

    /**
     * 需求商品的sku id
     */
    private Long skuId;

    /**
     * 退款结算类型
     * @see cn.com.duiba.quanyi.center.api.enums.coupon.SettlementDeadlineTypeEnum
     */
    private Integer settlementDeadlineType;

    /**
     * 项目id
     * tb_project.id
     */
    private Long projectId;
}
