package cn.com.duiba.quanyi.center.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityLimitConfigDto;
import cn.com.duiba.quanyi.center.api.dto.activity.ActivityUserReceiveLimitDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 活动白名单表
 *
 * @author lizhi
 * @date 2023/8/7 16:46
 */
@AdvancedFeignClient
public interface RemoteTemplateActivityService {

    /**
     * 校验是否命中活动限制
     * @param userId
     * @param activityId
     * @param prizeId
     * @return
     */
    Boolean checkLimitConfig(Long userId, Long activityId, Long prizeId);

    /**
     * 批量校验是否命中活动限制
     * @param userId 用户id
     * @param activityId 活动id
     * @param prizeIds 奖品id
     * @return 命中集合
     */
    Map<Long,Boolean> batchCheckLimitConfig(Long userId, Long activityId, List<Long> prizeIds);

    /**
     * 根据周期查询用户领奖次数
     * @param now
     * @param userIds
     * @param activityId
     * @param prizeIds
     * @return
     * @throws BizException
     */
    ActivityUserReceiveLimitDto selectUsersReceiveCountByCycle(Date now, List<Long> userIds, Long activityId, List<Long> prizeIds);


    /**
     * 校验用户是否在领奖时间内
     * @param activityLimitConfigDto
     * @return
     */
    Boolean checkLimitDay(ActivityLimitConfigDto activityLimitConfigDto);

    /**
     * 根据支付活动维度获取直接领奖限制
     * @param activityId
     * @param userId
     * @param prizeIdList
     * @return 奖品ID：是否能够领奖 true:是 false:否
     */
    Map<Long,Boolean> getPayDrawLimitByDirectActivityScope(Long activityId, Long userId, List<Long> prizeIdList);

    /**
     * 根据支付奖品维度获取直接领奖限制
     * @param activityId
     * @param userId
     * @param prizeIdList
     * @return 是否能够领奖 true:是 false:否
     */
    Map<Long, Boolean> getPayDrawLimitByDirectPrizeScope(Long activityId, Long userId, List<Long> prizeIdList,String value);

    /**
     * 根据支付活动维度获取概率领奖限制
     * @param activityId
     * @param userId
     * @return 是否能够领奖 true:是 false:否
     */
    Boolean getPayDrawLimitByProbabilityActivityScope(Long activityId, Long userId);

    /**
     * 根据领奖限制周期查询用户领奖次数
     * @param userId 用户UserId
     * @param activityId 活动Id
     * @param prizeIds 活动奖品Id
     * @param drawLimitType 领奖限制 {@link cn.com.duiba.quanyi.center.api.enums.activity.ActivityLimitConfigEnum}
     * @return 某个用户的奖品领取记录数量
     */
   int getUserReceiveRecordCntByLimitConfig(Long userId, Long activityId, List<Long> prizeIds, Integer drawLimitType);
}
